import os
from dotenv import load_dotenv

# Load environment variables from .env file, if it exists
load_dotenv(override=True)  # Override system environment variables

# Bot configuration
BOT_TOKEN = os.getenv("BOT_TOKEN",
                      "8071791443:AAHbExV8wOZ6bUX5d_bvRdMb8-8_kHikaDk")
BOT_NAME = "РазДваВПН"

# Admin configuration
ADMIN_IDS = [int(id) for id in os.getenv("ADMIN_IDS", "").split(",") if id
             ] or [7021451750]  # ID администраторов бота

# Database configuration - Use PostgreSQL as primary database
DATABASE_FILE = "database/vpnbot.db"  # Kept for backup purposes


def setup_database():
    """Настраивает базу данных - ТОЛЬКО PostgreSQL"""
    # Принудительно проверяем наличие PostgreSQL
    if 'DATABASE_URL' in os.environ and 'postgresql' in os.environ[
            'DATABASE_URL']:
        print(f"✓ PostgreSQL активен: {os.environ['DATABASE_URL'][:50]}...")
        return os.environ['DATABASE_URL']

    # Если PostgreSQL переменные доступны, формируем URL
    if all(var in os.environ
           for var in ['PGHOST', 'PGUSER', 'PGPASSWORD', 'PGDATABASE']):
        pg_url = f"postgresql://{os.environ.get('PGUSER')}:{os.environ.get('PGPASSWORD')}@{os.environ.get('PGHOST')}:{os.environ.get('PGPORT', '5432')}/{os.environ.get('PGDATABASE')}"
        os.environ['DATABASE_URL'] = pg_url
        print(f"✓ PostgreSQL сконфигурирован: {pg_url[:50]}...")
        return pg_url

    # Ошибка если PostgreSQL недоступен
    raise Exception(
        "❌ PostgreSQL база данных недоступна! SQLite деактивирована для тестирования."
    )


# Настраиваем базу данных
DATABASE_URL = setup_database()

# 3x-ui panel configuration
PANEL_BASE_URL = os.getenv("PANEL_BASE_URL",
                           "https://31.172.75.92:47773")  # Базовый URL сервера
PANEL_PATH = os.getenv("PANEL_PATH", "/Sh1YLmgVQZ7cgcS").rstrip(
    '/')  # Корневой путь к панели без завершающего слеша
PANEL_URL = f"{PANEL_BASE_URL}{PANEL_PATH}"  # Полный URL панели
PANEL_API_URL = f"{PANEL_URL}"  # URL для API
PANEL_LOGIN_URL = f"{PANEL_URL}/login"  # URL страницы логина
PANEL_USERNAME = os.getenv("PANEL_USERNAME",
                           "VVShilin")  # Имя пользователя для панели
PANEL_PASSWORD = os.getenv("PANEL_PASSWORD",
                           "Kat@11122012")  # Пароль для панели
PANEL_TIMEOUT = int(os.getenv("PANEL_TIMEOUT",
                              "3600"))  # Таймаут сессии в секундах (1 час)

# VPN configuration
VPN_SETTINGS = {
    "server_address": "31.172.75.92",  # VPN сервер - адрес сервера Shadowsocks
    "port": 48839,  # Порт для подключения клиентов
    "method": "aes-256-gcm",  # Метод шифрования Shadowsocks
    "protocol": "shadowsocks",  # Используемый протокол
    "protocol_id": 3,  # ID протокола в панели 3x-ui
    "protocol_vless_id": 1,  # ID протокола VLESS в панели 3x-ui
    "inbound_id":
    3,  # ID инбаунда для клиентов (обычно совпадает с protocol_id)
    "default_traffic_limit_gb":
    50,  # Стандартный лимит трафика для новых аккаунтов в ГБ
    "timeout_seconds": 5,  # Таймаут для запросов к API и тестов соединения
    "connection_retries": 3,  # Количество попыток соединения при сбоях
    "fallback_enabled":
    True,  # Включение резервного механизма при недоступности API
    "shadowsocks_method":
    "chacha20-ietf-poly1305"  # Альтернативный метод шифрования
}

# YooKassa configuration (LIVE)
YOOKASSA_SHOP_ID = os.getenv("YOOKASSA_SHOP_ID", "1086956")
YOOKASSA_SECRET_KEY = os.getenv(
    "YOOKASSA_SECRET_KEY", "live_ZHGkqoE-FSbL-VjA62Y6rBICY8p98DsRyX9Ob5S2rHg")
YOOKASSA_RETURN_URL = os.getenv("YOOKASSA_RETURN_URL",
                                "https://t.me/RazDvaVPN_bot")


# Webhook URL configuration - продакшн URL
def get_webhook_url():
    """Определяет правильный webhook URL в зависимости от среды"""
    # Продакшн URL для YooKassa
    production_url = "https://82.202.130.91.nip.io/yookassa-webhook"
    
    # Если явно задан в переменных окружения (для VPS)
    if os.getenv("WEBHOOK_URL"):
        return os.getenv("WEBHOOK_URL")

    # Используем продакшн URL
    return production_url
    return "http://localhost:5000/yookassa-webhook"


YOOKASSA_WEBHOOK_URL = get_webhook_url()

# Subscription plans
SUBSCRIPTION_PLANS = {
    "weekly": {
        "name": "На Недельку",
        "price": 75,
        "traffic_gb": 20,
        "duration_days": 7,
        "description": "Тариф на неделю: 7 дней 20 ГБ трафика"
    },
    "trial": {
        "name": "Тестовый Период",
        "price": 0,
        "traffic_gb": 10,
        "duration_days": 3,
        "description": "Тестовый тариф: на 3 дня -10 ГБ трафика"
    },
    "basic": {
        "name": "Базовый",
        "price": 150,
        "traffic_gb": 150,
        "duration_days": 30,
        "description": "Базовый тариф: на 30 дней -150 ГБ трафика"
    },
    "standard": {
        "name": "Стандарт",
        "price": 425,
        "traffic_gb": 500,
        "duration_days": 90,
        "description": "Стандартный тариф: на 90 дней -500 ГБ трафика",
        "discount_percent": 5.5,
        "price_per_30_days": 141.7
    },
    "premium": {
        "name": "Премиум",
        "price": 810,
        "traffic_gb": 1100,
        "duration_days": 185,
        "description": "Премиум тариф: на 185 дней -1100 ГБ трафика",
        "discount_percent": 10,
        "price_per_30_days": 131.4
    },
    "lux": {
        "name": "Люкс",
        "price": 1260,
        "traffic_gb": 2300,
        "duration_days": 380,
        "description": "Люкс тариф: на 380 дней -2300 ГБ трафика",
        "discount_percent": 30,
        "price_per_30_days": 99.5
    }
}

# ТЕСТОВЫЕ ТАРИФЫ ДЛЯ ПРОВЕРКИ YOOKASSA (ЗАКОММЕНТИРОВАНЫ)
# Эти тарифы использовались только для тестирования платежной системы
# НЕ ИСПОЛЬЗОВАТЬ В ПРОДАКШЕНЕ!
"""
TEST_PLANS_FOR_YOOKASSA_ONLY = {
    "test_basic": {
        "name": "Базовый (ТЕСТ)",
        "price": 199,
        "traffic_gb": 25,
        "duration_days": 7,
        "description": "ТЕСТОВЫЙ тариф для проверки YooKassa: 25 ГБ на 7 дней"
    },
    "test_weekly": {
        "name": "Недельный+ (ТЕСТ)", 
        "price": 349,
        "traffic_gb": 50,
        "duration_days": 14,
        "description": "ТЕСТОВЫЙ тариф для проверки YooKassa: 50 ГБ на 14 дней"
    },
    "test_monthly": {
        "name": "Месячный (ТЕСТ)",
        "price": 599,
        "traffic_gb": 100,
        "duration_days": 30,
        "description": "ТЕСТОВЫЙ тариф для проверки YooKassa: 100 ГБ на 30 дней"
    }
}
"""

# Notification settings - упрощенная логика
# Только два типа: тестовые периоды и оплаченные подписки
NOTIFICATION_SETTINGS = {
    "trial": {
        "days_before": [0, 1, 2, 3],
        "send_time_start": 9,  # С 9 утра
        "send_time_end": 21,  # До 21 вечера
        "check_interval_hours": 1  # Каждый час
    },
    "paid": {
        "days_before": [1, 3, 5, 7],
        "send_time_start": 9,  # С 9 утра  
        "send_time_end": 21,  # До 21 вечера
        "check_interval_hours": 6  # Каждые 6 часов
    }
}

# Для обратной совместимости (старый код)
NOTIFICATION_DAYS_BEFORE_EXPIRY = [1, 3, 5, 7]
TRAFFIC_WARNING_THRESHOLD = 0.1  # 10% remaining

# Параметры тестового периода
TEST_PERIOD_DAYS = 3  # Продолжительность тестового периода в днях
TEST_PERIOD_TRAFFIC_GB = 10  # Лимит трафика для тестового периода в ГБ
INBOUND_ID = VPN_SETTINGS[
    "protocol_vless_id"]  # Использовать VLESS протокол для тестового периода

# Конфигурация для расширений (если понадобится в будущем)
# Место для дополнительных параметров конфигурации

# Класс для хранения созданных клиентов (для тестирования и разработки)
import os
import json
import logging


class ClientStorage:

    def __init__(self):
        self.clients = []
        self.storage_path = "client_storage.json"
        self._load_from_disk()

    def add_client(self, client_data):
        # Проверяем, что клиент с таким email еще не существует
        email = client_data.get("email", "")
        existing_clients = [c for c in self.clients if c.get("email") == email]
        if existing_clients:
            logging.info(f"Клиент с email {email} уже существует в хранилище")
            return len(self.clients)

        self.clients.append(client_data)
        self._save_to_disk()
        return len(self.clients)

    def get_clients(self):
        self._load_from_disk()
        return self.clients

    def clear(self):
        self.clients = []
        self._save_to_disk()

    def _load_from_disk(self):
        try:
            if os.path.exists(self.storage_path):
                with open(self.storage_path, "r") as f:
                    self.clients = json.load(f)
                logging.info(
                    f"Загружено {len(self.clients)} клиентов из хранилища")
        except Exception as e:
            logging.error(f"Ошибка при загрузке клиентов из хранилища: {e}")
            self.clients = []

    def _save_to_disk(self):
        try:
            with open(self.storage_path, "w") as f:
                json.dump(self.clients, f)
            logging.info(f"Сохранено {len(self.clients)} клиентов в хранилище")
        except Exception as e:
            logging.error(f"Ошибка при сохранении клиентов в хранилище: {e}")


# Создаем экземпляр хранилища клиентов
CREATED_CLIENTS = ClientStorage()
