"""
Helper functions for robust message handling in Telegram bot
"""
from aiogram.types import CallbackQuery, Message
from aiogram.utils.keyboard import InlineKeyboardBuilder, ReplyKeyboardBuilder
from aiogram.types import InlineKeyboardMarkup, ReplyKeyboardMarkup
import logging

logger = logging.getLogger(__name__)


async def safe_edit_or_send(callback: CallbackQuery, text: str, reply_markup=None, parse_mode="HTML"):
    """
    Safely edit message or send new one if edit fails
    Handles cases where message contains media or can't be edited
    """
    try:
        if callback.message:
            await callback.message.edit_text(
                text=text,
                reply_markup=reply_markup,
                parse_mode=parse_mode
            )
    except Exception as e:
        logger.debug(f"Edit failed, sending new message: {e}")
        # If edit fails, send new message
        if callback.message:
            await callback.message.answer(
                text=text,
                reply_markup=reply_markup,
                parse_mode=parse_mode
            )


async def safe_answer_callback(callback: CallbackQuery, text: str = None, show_alert: bool = False):
    """
    Safely answer callback query
    """
    try:
        await callback.answer(text=text, show_alert=show_alert)
    except Exception as e:
        logger.debug(f"Callback answer failed: {e}")