from aiogram.utils.keyboard import ReplyKeyboardBuilder, InlineKeyboardBuilder
from aiogram.types import ReplyKeyboardMarkup, InlineKeyboardMarkup

from config import SUBSCRIPTION_PLANS


def get_main_menu_keyboard() -> ReplyKeyboardMarkup:
    """Get main menu keyboard with 5 buttons"""
    kb = ReplyKeyboardBuilder()
    
    # Add buttons
    kb.button(text="Выбрать Тариф")
    kb.button(text="Продлить Подписку")
    kb.button(text="Информация о Тарифах")
    kb.button(text="Личный Кабинет")
    kb.button(text="Доп. Сервисы")
    
    # Arrange buttons: 2 rows of 2, then 1 button in third row
    kb.adjust(2, 2, 1)
    
    return kb.as_markup(resize_keyboard=True)


def get_back_to_menu_inline() -> InlineKeyboardMarkup:
    """Get inline keyboard with back to menu button for editing messages"""
    kb = InlineKeyboardBuilder()
    kb.button(text="⬅️ В главное меню", callback_data="back_to_menu")
    return kb.as_markup()


def get_personal_account_keyboard() -> ReplyKeyboardMarkup:
    """Get personal account menu keyboard"""
    kb = ReplyKeyboardBuilder()
    
    # Add buttons
    kb.button(text="Текущая Подписка")
    kb.button(text="Мои Платежи")
    kb.button(text="Помощь")
    kb.button(text="Назад в меню")
    
    # Arrange buttons in 2 rows of 2 buttons
    kb.adjust(2, 2)
    
    return kb.as_markup(resize_keyboard=True)


def get_plans_keyboard() -> InlineKeyboardMarkup:
    """Get keyboard with available subscription plans"""
    kb = InlineKeyboardBuilder()
    
    # Add a button for each plan (excluding trial)
    for plan_id, plan in SUBSCRIPTION_PLANS.items():
        if plan_id != "trial":  # Exclude trial period from paid plans
            days_text = "3 дня" if plan['duration_days'] == 3 else f"{plan['duration_days']} дней"
            kb.button(
                text=f"{plan['name']} - {days_text} ({plan['traffic_gb']} ГБ) - {plan['price']} руб.",
                callback_data=plan_id
            )
    
    # Arrange buttons vertically
    kb.adjust(1)
    
    return kb.as_markup()



