"""
Простой API для панели 3X-UI
Используется в main.py для проверки подключения
"""

import logging
import aiohttp
from config import PANEL_API_URL, PANEL_USERNAME, PANEL_PASSWORD

logger = logging.getLogger(__name__)

class SimplePanelAPI:
    def __init__(self):
        self.base_url = PANEL_API_URL.rstrip('/')
        self.username = PANEL_USERNAME
        self.password = PANEL_PASSWORD
        self.session = None
        self.cookies = None

    async def _ensure_session(self):
        """Обеспечить наличие сессии"""
        if not self.session:
            self.session = aiohttp.ClientSession()
        
        if not self.cookies:
            await self._login()

    async def close(self):
        """Закрыть сессию"""
        if self.session:
            await self.session.close()
            self.session = None
            self.cookies = None

    async def _login(self):
        """Авторизация в панели"""
        try:
            login_data = {
                "username": self.username,
                "password": self.password
            }
            
            async with self.session.post(f"{self.base_url}/login", data=login_data) as response:
                if response.status == 200:
                    self.cookies = response.cookies
                    return True
                else:
                    return False
        except Exception as e:
            logger.error(f"Ошибка авторизации: {e}")
            return False

    async def get_traffic_by_email(self, email: str):
        """Получить трафик по email (для тестирования подключения)"""
        try:
            await self._ensure_session()
            
            # Простой запрос для проверки подключения
            async with self.session.get(f"{self.base_url}/panel/api/inbounds/list", cookies=self.cookies) as response:
                if response.status == 200:
                    return {"status": "connected"}
                else:
                    return None
        except Exception as e:
            logger.error(f"Ошибка при проверке трафика: {e}")
            return None

    async def close(self):
        """Закрыть сессию"""
        if self.session:
            await self.session.close()

# Глобальный экземпляр
simple_panel_api = SimplePanelAPI()