BEGIN TRANSACTION;
CREATE TABLE notification_log (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            user_id INTEGER NOT NULL,
            subscription_id INTEGER,
            notification_type TEXT NOT NULL,
            days_before_expiry INTEGER,
            message TEXT,
            success INTEGER NOT NULL DEFAULT 0,
            error_message TEXT,
            sent_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        );
CREATE TABLE notification_settings (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            plan_type TEXT NOT NULL,
            days_before_expiry INTEGER NOT NULL,
            notification_time TEXT NOT NULL DEFAULT '10:00',
            enabled INTEGER NOT NULL DEFAULT 1,
            message_template TEXT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        , send_time_start TEXT DEFAULT '09:00', send_time_end TEXT DEFAULT '18:00');
INSERT INTO "notification_settings" VALUES(1,'trial',0,'10:00',1,'Ваша тестовая подписка истекает сегодня!','2025-06-27 10:33:03','2025-06-27 10:33:03','09:00','18:00');
INSERT INTO "notification_settings" VALUES(2,'trial',1,'10:00',1,'Ваша тестовая подписка истекает завтра!','2025-06-27 10:33:03','2025-06-27 10:33:03','09:00','18:00');
INSERT INTO "notification_settings" VALUES(3,'paid',0,'10:00',1,'Ваша подписка истекает сегодня!','2025-06-27 10:33:03','2025-06-27 10:33:03','09:00','18:00');
INSERT INTO "notification_settings" VALUES(4,'paid',1,'10:00',1,'Ваша подписка истекает завтра!','2025-06-27 10:33:03','2025-06-27 10:33:03','09:00','18:00');
INSERT INTO "notification_settings" VALUES(5,'paid',3,'10:00',1,'Ваша подписка истекает через 3 дня!','2025-06-27 10:33:03','2025-06-27 10:33:03','09:00','18:00');
DELETE FROM "sqlite_sequence";
INSERT INTO "sqlite_sequence" VALUES('notification_settings',5);
COMMIT;
