from aiogram.fsm.state import State, StatesGroup


class SubscriptionStates(StatesGroup):
    """States for subscription creation process"""
    selecting_plan = State()
    confirming_payment = State()
    awaiting_payment = State()


class PaymentStates(StatesGroup):
    """States for payment process"""
    selecting_extension = State()
    selecting_new_plan = State()
    confirming_payment = State()
    awaiting_payment = State()


class PersonalStates(StatesGroup):
    """States for personal account interactions"""
    viewing_subscription = State()
    viewing_payments = State()
    viewing_help = State()
