from app import db
from sqlalchemy import JSON
from datetime import datetime

class NotificationSettings(db.Model):
    """Настройки уведомлений для разных тарифов"""
    __tablename__ = 'notification_settings'
    
    id = db.Column(db.Integer, primary_key=True)
    plan_id = db.Column(db.String(50), unique=True, nullable=False)  # trial, basic, premium, etc.
    plan_name = db.Column(db.String(100), nullable=False)
    days_before = db.Column(JSON, nullable=False)  # Список дней [0, 1, 2, 3]
    send_time_start = db.Column(db.Integer, default=9)  # Час начала отправки
    send_time_end = db.Column(db.Integer, default=21)    # Час окончания отправки
    check_interval_hours = db.Column(db.Integer, default=1)  # Интервал проверки в часах
    enabled = db.Column(db.Boolean, default=True)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    updated_at = db.Column(db.DateTime, default=datetime.utcnow, onupdate=datetime.utcnow)

class NotificationLog(db.Model):
    """Лог отправленных уведомлений"""
    __tablename__ = 'notification_log'
    
    id = db.Column(db.Integer, primary_key=True)
    user_id = db.Column(db.Integer, nullable=False)
    subscription_id = db.Column(db.Integer, nullable=False)
    notification_type = db.Column(db.String(50), nullable=False)  # expiry, traffic_warning
    days_before_expiry = db.Column(db.Integer)
    message_text = db.Column(db.Text)
    sent_at = db.Column(db.DateTime, default=datetime.utcnow)
    success = db.Column(db.Boolean, default=True)
    error_message = db.Column(db.Text)

class NotificationQueue(db.Model):
    """Очередь уведомлений для отправки"""
    __tablename__ = 'notification_queue'
    
    id = db.Column(db.Integer, primary_key=True)
    user_id = db.Column(db.Integer, nullable=False)
    subscription_id = db.Column(db.Integer, nullable=False)
    notification_type = db.Column(db.String(50), nullable=False)
    days_before_expiry = db.Column(db.Integer)
    scheduled_at = db.Column(db.DateTime, nullable=False)
    sent = db.Column(db.Boolean, default=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)