"""
Простой API для работы с панелью 3X-UI без сложного менеджера сессий
"""
import logging
import aiohttp
import ssl
from typing import Optional, Dict, Any

logger = logging.getLogger(__name__)

class SimplePanelAPI:
    def __init__(self):
        self.panel_url = "https://31.172.75.92:47773/Sh1YLmgVQZ7cgcS"
        self.username = "VVShilin"
        self.password = "Kat@11122012"
        
        # SSL контекст для самоподписанных сертификатов
        self._ssl_context = ssl.create_default_context()
        self._ssl_context.check_hostname = False
        self._ssl_context.verify_mode = ssl.CERT_NONE
    
    async def get_traffic_by_email(self, email: str) -> Optional[Dict[str, Any]]:
        """Получает данные о трафике клиента по email"""
        connector = aiohttp.TCPConnector(ssl=self._ssl_context)
        
        async with aiohttp.ClientSession(connector=connector) as session:
            try:
                # Авторизуемся согласно документации API (form-data, не JSON)
                login_url = f"{self.panel_url}/login"
                login_data = {"username": self.username, "password": self.password}
                
                async with session.post(login_url, data=login_data) as response:
                    if response.status != 200:
                        logger.error(f"Ошибка авторизации: {response.status}")
                        return None
                    
                    # Проверяем что получили cookie "3x-ui"
                    cookies = session.cookie_jar.filter_cookies(response.url)
                    has_session = any(cookie.key == "3x-ui" for cookie in cookies)
                    if not has_session:
                        logger.error("Не получен cookie '3x-ui' после авторизации")
                        return None
                    
                    logger.debug("Успешная авторизация, cookie получен")
                
                # Получаем трафик
                traffic_url = f"{self.panel_url}/panel/api/inbounds/getClientTraffics/{email}"
                
                async with session.get(traffic_url) as response:
                    if response.status != 200:
                        logger.error(f"Ошибка получения трафика: {response.status}")
                        return None
                    
                    content_type = response.headers.get('content-type', '')
                    if 'application/json' not in content_type:
                        logger.error(f"Получен неправильный тип содержимого: {content_type}")
                        return None
                    
                    data = await response.json()
                    
                    if not data.get("success"):
                        logger.error(f"API ошибка: {data.get('msg', 'Unknown')}")
                        return None
                    
                    obj = data.get("obj")
                    if not obj:
                        logger.warning(f"Нет данных о трафике для {email}")
                        return None
                    
                    # Возвращаем данные
                    return {
                        "up": obj.get("up", 0),
                        "down": obj.get("down", 0),
                        "traffic_used": obj.get("up", 0) + obj.get("down", 0)
                    }
                    
            except Exception as e:
                logger.error(f"Ошибка при получении трафика для {email}: {e}")
                return None

# Глобальный экземпляр
simple_panel_api = SimplePanelAPI()