"""
Модуль с улучшенными обработчиками для бота, заменяющими или дополняющими стандартные
"""

import logging
import asyncio
from aiogram import types
from aiogram.types import Message, CallbackQuery
from aiogram import F, Router

# Настройка логирования
logger = logging.getLogger(__name__)

# Создаем роутер
router = Router(name="enhanced_handlers_router")

@router.callback_query(F.data.startswith("refresh_link|"))
async def refresh_client_link(callback_query: CallbackQuery):
    """Перенаправляет на обработчик в оптимизированном модуле refresh_link"""
    # Для предотвращения символа часов в интерфейсе
    await callback_query.answer()
    
    # Импортируем функцию из оптимизированного модуля
    from bot.handlers.optimized_refresh_link import refresh_client_link as refresh_link_handler
    
    # Вызываем обработчик из оптимизированного модуля
    await refresh_link_handler(callback_query)

def register_handlers(dp):
    """Регистрация обработчиков"""
    dp.include_router(router)