"""
Утилиты для генерации email адресов для VPN клиентов
"""


def generate_vpn_email(user_id: int, username: str = None) -> str:
    """
    Генерирует email для VPN клиента по алгоритму ID@Username
    
    Args:
        user_id: Telegram ID пользователя
        username: Username пользователя (без @)
    
    Returns:
        str: Email в формате ID@Username или ID@User если username отсутствует
    """
    if username:
        # Убираем @ если он есть в начале username
        clean_username = username.lstrip('@')
        return f"{user_id}@{clean_username}"
    else:
        return f"{user_id}@User"


def validate_vpn_email(email: str) -> bool:
    """
    Проверяет валидность email для VPN клиента
    
    Args:
        email: Email адрес для проверки
    
    Returns:
        bool: True если email валиден
    """
    if not email or '@' not in email:
        return False
    
    parts = email.split('@')
    if len(parts) != 2:
        return False
    
    user_id_part, username_part = parts
    
    # Проверяем что первая часть - это число (user_id)
    try:
        int(user_id_part)
    except ValueError:
        return False
    
    # Проверяем что вторая часть не пустая
    if not username_part:
        return False
    
    return True